/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import com.vldocking.swing.docking.event.DockEvent;
import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TabbedDockView
extends DockView {
    private static final long serialVersionUID = 1L;

    public TabbedDockView(Dockable dockable) {
        super(dockable, false);
    }

    @Override
    protected void scanDrop(DockEvent event, boolean drop) {
        DockableState.Location location = this.dockable.getDockKey().getLocation();
        if (location == DockableState.Location.DOCKED) {
            super.scanDrop(event, drop);
        } else if (location == DockableState.Location.FLOATING) {
            if (DockingUtilities.isChildOfCompoundDockable(this.dockable)) {
                super.scanDrop(event, drop);
            } else if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && UIManager.getBoolean("TabbedContainer.requestFocusOnTabSelection")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component comp;
                    if (TabbedDockView.this.getDockable() != null && (comp = TabbedDockView.this.getDockable().getComponent()) != null) {
                        comp.requestFocus();
                    }
                }
            });
        }
    }
}

