//Copyright 2007 Calculate Pack, http://www.calculate-linux.ru
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
// 
//      http://www.apache.org/licenses/LICENSE-2.0
// 
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

// для пароля
#include <sys/types.h>
#include <pwd.h>

// для strcpy strlen
#include <string.h>

// для работы с ключами
#include <keyutils.h>

//Статистика файла
 #include <fcntl.h>
 #include <sys/stat.h>

int main( int argc, const char* argv[] )
{
  // идентификатор пользователя
  uid_t uid, gid;
  int ret;
  int rez1,rez2;
  void *buffer;
  if (argc==1)
    {
      // получаем id и группу пользователя
      uid = getuid();
      gid = getgid();
      //Устанавливаем права пользователя на этот процесс
      rez1 = setgid(gid);
      rez2 = setuid(uid);
      if (rez1==-1||rez2==-1)
        {
          printf ("exec not SUID root\n");
          exit(EXIT_FAILURE);
        };
      // ищем номер пользовательского ключа
      ret = request_key("user", "tmp", NULL, 0);
      if (ret < 0)
        {
          printf ("id_key not found\n");
          exit(EXIT_FAILURE);
        };
      // Возвращаем значение ключа
      int retf;
      retf = keyctl_read_alloc(ret, &buffer);
      if (retf < 0)
        {
          printf("error keyctl_read_alloc\n");
          exit(EXIT_FAILURE);
        };
      printf ("%s",buffer);
      buffer = "XXXXXXXX";
      key_serial_t dest;
      // Получаем id пользовательског ключа
      dest = KEY_SPEC_USER_SESSION_KEYRING;
      // записываем ключ в пространство user
      ret = add_key("user", "tmp", buffer, strlen(buffer), dest);
      exit(EXIT_SUCCESS);
    };
  if (argc!=3)
    {
      printf("Error: needed two argument\n");
      exit(EXIT_FAILURE);
    }

  // получаем id и группу пользователя
  uid = getuid();
  gid = getgid();

  char * prog_name[10];
  char * prog_path[10];
  char * prog_sring[10];
  int count_prog =10;

  // идентификатор и путь к программе
  prog_name[0] = "rdesktop";
  prog_path[0] = "/usr/bin/rdesktop";
  prog_sring[0] = "";
  prog_name[1] = "rdesktop1";
  prog_path[1] = "/usr/bin/rdesktop";
  prog_sring[1] = "/usr/bin/kstart --window=.* --desktop=1";
  prog_name[2] = "rdesktop2";
  prog_path[2] = "/usr/bin/rdesktop";
  prog_sring[2] = "/usr/bin/kstart --window=.* --desktop=2";
  prog_name[3] = "rdesktop3";
  prog_path[3] = "/usr/bin/rdesktop";
  prog_sring[3] = "/usr/bin/kstart --window=.* --desktop=3";
  prog_name[4] = "rdesktop4";
  prog_path[4] = "/usr/bin/rdesktop";
  prog_sring[4] = "/usr/bin/kstart --window=.* --desktop=4";
  prog_name[5] = "rdesktop5";
  prog_path[5] = "/usr/bin/rdesktop";
  prog_sring[5] = "/usr/bin/kstart --window=.* --desktop=5";
  prog_name[6] = "rdesktop6";
  prog_path[6] = "/usr/bin/rdesktop";
  prog_sring[6] = "/usr/bin/kstart --window=.* --desktop=6";
  prog_name[7] = "rdesktop7";
  prog_path[7] = "/usr/bin/rdesktop";
  prog_sring[7] = "/usr/bin/kstart --window=.* --desktop=7";
  prog_name[8] = "rdesktop8";
  prog_path[8] = "/usr/bin/rdesktop";
  prog_sring[8] = "/usr/bin/kstart --window=.* --desktop=8";
  prog_name[9] = "rdesktop9";
  prog_path[9] = "/usr/bin/rdesktop";
  prog_sring[9] = "/usr/bin/kstart --window=.* --desktop=9";
  // путь к выполняемой программе
  char * str_prog = NULL;
//   В случае kstart
  char * str_prog_ks = NULL;
  
  int i;
  for (i=0;i<count_prog;i++)
    {
      if (strcmp(prog_name[i],argv[1])==0)
        {
          str_prog = prog_path[i];
          str_prog_ks = prog_sring[i];
          break;
        };
    };

  if (str_prog == NULL)
    {
      printf ("False program\n");
      exit(EXIT_FAILURE); 
    };

  struct stat bufS;
  int res;
  int fd;
  // Права файла на которые его проверяем
  int mode_file = 33261;
  fd = open(str_prog, O_RDONLY);
  res = fstat(fd,&bufS);

  if (res==0)
    {
      close(fd);
    }else
    {
      printf("No open file %s\n",str_prog);
      exit(EXIT_FAILURE);
    };
  // Сравнение прав и владельца исполняемого файла с образцом
  if (bufS.st_mode == mode_file && bufS.st_uid == 0 && bufS.st_gid == 0)
    {
      struct passwd *pwd = getpwuid (uid);
      if (pwd == NULL)
        {
          exit(EXIT_FAILURE);
        };
      // Получение имени пользователя
      char *login;
      login = (char*) malloc (strlen(pwd->pw_name)+1);
      strcpy (login,pwd->pw_name);

      //устанавливаем права рута
      rez1 = setgid(0);
      rez2 = setuid(0);

      if (rez1==-1||rez2==-1)
        {
          printf ("Exec not SUID root\n");
          exit(EXIT_FAILURE);
        };

      int ret;
      // ищем номер пользовательского ключа
      ret = request_key("user", login, NULL, 0);
      if (ret < 0)
        {
          printf ("id_key not found\n");
          exit(EXIT_FAILURE);
        };

      // Возвращаем значение ключа
      ret = keyctl_read_alloc(ret, &buffer);
      if (ret < 0)
        {
          printf("error keyctl_read_alloc\n");
          exit(EXIT_FAILURE);
        }
      //Устанавливаем права пользователя на этот процесс
      rez1 = setgid(gid);
      rez2 = setuid(uid);
      if (rez1==-1||rez2==-1)
        {
          printf ("exec not SUID root\n");
          exit(EXIT_FAILURE);
        };
      key_serial_t dest;
      // Получаем id пользовательског ключа
      dest = KEY_SPEC_USER_SESSION_KEYRING;
      //printf("DEST=%d\n",dest);

      // записываем ключ в пространство user
      ret = add_key("user", "tmp", buffer, strlen(buffer), dest);
      //printf("RET=%d\n",ret);
      //Распределяем память и создаем строку запуска
      char *buff;
      if (str_prog_ks == "")
        {
          char *com = "keyexec | %s %s";
          buff = (char*) malloc (strlen(com)+strlen(str_prog)+strlen(argv[2])+1);
          sprintf (buff, com, str_prog, argv[2]);
        }
      else
        {
          char *com = "%s keyexec | %s %s";
          buff = (char*) malloc (strlen(str_prog_ks)+strlen(com)+strlen(buffer)+strlen(str_prog)+strlen(argv[2])+1);
          sprintf (buff, com, str_prog_ks, str_prog, argv[2]);
        };
      //Выполнение программы 
      system(buff);
      free(login);
      free (buff);
      exit(EXIT_SUCCESS);
    };
  printf ("Executed file %s not valid\n",str_prog);
  exit(EXIT_FAILURE);
}
