/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.XPathException;

public class IntegerRangeTest
extends ComputedExpression {
    Expression value;
    Expression min;
    Expression max;

    public IntegerRangeTest(Expression expression, Expression expression2, Expression expression3) {
        this.value = expression;
        this.min = expression2;
        this.max = expression3;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 512;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        IntegerValue integerValue;
        AtomicValue atomicValue2 = (AtomicValue)this.value.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return BooleanValue.FALSE;
        }
        IntegerValue integerValue2 = (IntegerValue)atomicValue2.getPrimitiveValue();
        long l = integerValue2.getValue();
        if (l < (integerValue = (IntegerValue)(atomicValue = (AtomicValue)this.min.evaluateItem(xPathContext)).getPrimitiveValue()).getValue()) {
            return BooleanValue.FALSE;
        }
        AtomicValue atomicValue3 = (AtomicValue)this.max.evaluateItem(xPathContext);
        IntegerValue integerValue3 = (IntegerValue)atomicValue3.getPrimitiveValue();
        return BooleanValue.get(l <= integerValue3.getValue());
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "rangeTest min<value<max");
        this.min.display(n + 1, namePool);
        this.value.display(n + 1, namePool);
        this.max.display(n + 1, namePool);
    }
}

