/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class NameCache {
    static final Object[][] _codes = new Object[][]{{Byte.TYPE, "B"}, {Character.TYPE, "C"}, {Double.TYPE, "D"}, {Float.TYPE, "F"}, {Integer.TYPE, "I"}, {Long.TYPE, "J"}, {Short.TYPE, "S"}, {Boolean.TYPE, "Z"}, {Void.TYPE, "V"}};
    private final Map _internal = new HashMap();
    private final Map _internalDescriptor = new HashMap();
    private final Map _external = new HashMap();
    private final Map _externalHuman = new HashMap();

    public String getInternalForm(String className, boolean descriptor) {
        if (className == null || className.length() == 0) {
            return className;
        }
        Map cache = descriptor ? this._internalDescriptor : this._internal;
        String cached = (String)cache.get(className);
        if (cached != null) {
            return cached;
        }
        String ret = this.getInternalFormInternal(className, descriptor);
        cache.put(className, ret);
        return ret;
    }

    private String getInternalFormInternal(String cls, boolean descriptor) {
        StringBuffer prefix = new StringBuffer();
        while (true) {
            if (cls.endsWith("[]")) {
                prefix.append("[");
                cls = cls.substring(0, cls.length() - 2);
                continue;
            }
            if (!cls.startsWith("[")) break;
            prefix.append("[");
            cls = cls.substring(1);
        }
        for (int i = 0; i < _codes.length; ++i) {
            if (!cls.equals(_codes[i][1].toString()) && !cls.equals(_codes[i][0].toString())) continue;
            return prefix.append(_codes[i][1]).toString();
        }
        if (cls.startsWith("L") && cls.endsWith(";")) {
            cls = cls.substring(1, cls.length() - 1);
        }
        cls = cls.replace('.', '/');
        if ((descriptor || prefix.length() > 0) && cls.charAt(0) != '(') {
            return prefix.append("L").append(cls).append(";").toString();
        }
        return prefix.append(cls).toString();
    }

    public String getExternalForm(String internalName, boolean humanReadable) {
        if (internalName == null || internalName.length() == 0) {
            return internalName;
        }
        Map cache = humanReadable ? this._externalHuman : this._external;
        String cached = (String)cache.get(internalName);
        if (cached != null) {
            return cached;
        }
        String ret = this.getExternalFormInternal(internalName, humanReadable);
        cache.put(internalName, ret);
        return ret;
    }

    private String getExternalFormInternal(String intern, boolean humanReadable) {
        if (!humanReadable) {
            for (int i = 0; i < _codes.length; ++i) {
                if (intern.equals(_codes[i][1].toString())) {
                    return _codes[i][0].toString();
                }
                if (!intern.equals(_codes[i][0].toString())) continue;
                return intern;
            }
            intern = this.getInternalForm(intern, false);
            return intern.replace('/', '.');
        }
        StringBuffer postfix = new StringBuffer(2);
        while (intern.startsWith("[")) {
            intern = intern.substring(1);
            postfix.append("[]");
        }
        if (intern.endsWith(";")) {
            intern = intern.substring(1, intern.length() - 1);
        }
        for (int i = 0; i < _codes.length; ++i) {
            if (!intern.equals(_codes[i][1].toString())) continue;
            return _codes[i][0].toString() + postfix;
        }
        return intern.replace('/', '.') + postfix;
    }

    public String getDescriptor(String returnType, String[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == null) {
                    throw new NullPointerException("paramTypes[" + i + "] = null");
                }
                buf.append(this.getInternalForm(paramTypes[i], true));
            }
        }
        buf.append(")");
        if (returnType == null) {
            throw new NullPointerException("returnType = null");
        }
        buf.append(this.getInternalForm(returnType, true));
        return buf.toString();
    }

    public String getDescriptorReturnName(String descriptor) {
        int index = descriptor.indexOf(41);
        if (index == -1) {
            return "";
        }
        return descriptor.substring(descriptor.indexOf(41) + 1);
    }

    public String[] getDescriptorParamNames(String descriptor) {
        if (descriptor == null || descriptor.length() == 0) {
            return new String[0];
        }
        int index = descriptor.indexOf(41);
        if (index == -1) {
            return new String[0];
        }
        descriptor = descriptor.substring(1, index);
        LinkedList<String> tokens = new LinkedList<String>();
        while (descriptor.length() > 0) {
            index = 0;
            while (!Character.isLetter(descriptor.charAt(index))) {
                ++index;
            }
            if (descriptor.charAt(index) == 'L') {
                index = descriptor.indexOf(59);
            }
            tokens.add(descriptor.substring(0, index + 1));
            descriptor = descriptor.substring(index + 1);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public String getComponentName(String name) {
        if (name == null || !name.startsWith("[")) {
            return null;
        }
        if (!(name = name.substring(1)).startsWith("[") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        return this.getExternalForm(name, false);
    }

    public void clear() {
        this._internal.clear();
        this._internalDescriptor.clear();
        this._external.clear();
        this._externalHuman.clear();
    }
}

