/**
 * OWASP Enterprise Security API (ESAPI)
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * Enterprise Security API (ESAPI) project. For details, please see
 * <a href="http://www.owasp.org/index.php/ESAPI">http://www.owasp.org/index.php/ESAPI</a>.
 *
 * Copyright (c) 2009 - The OWASP Foundation
 * 
 * The ESAPI is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Arshan Dabirsiaghi <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @created 2009
 */
package org.owasp.esapi.waf;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import org.owasp.esapi.http.MockFilterChain;

import junit.framework.TestSuite;

public class HttpOnlyTest extends WAFTestCase {
	
	public static TestSuite suite() {
		return new TestSuite(HttpOnlyTest.class);
	}
	
    /*
     * Test all aspects of the HTTPOnly protection. Note that attaching HTTPOnly to
     * JSESSIONIDs requires a 3-step handshake, so the first 2 response codes should 
     * be 301, and on the 3rd response the cookie should be set. A lot of extra traffic
     * for HTTPOnly.
     * 
     * That same 3-step handshake won't be needed for custom cookies generated by the
     * application with addCookie().
     */

	// this has been commented because we decided not to try to make this work. too much
	// hackery.
	/*
    public void testAddHttpOnlyOnSessionCookie() throws Exception {
    	
     	System.out.println("addHttpOnlyPolicy - Response should have httpOnly set on the session ID (JSESSIONID) cookie added to response" );
   	        	
    	WAFTestUtility.createAndExecuteWAFTransaction( "waf-policies/add-httponly-policy.xml", request, response );
    	
    	assertTrue( response.getStatus() == HttpServletResponse.SC_MOVED_PERMANENTLY );
    	
    }
    */
	
    public void testAddHttpOnlyOnCustomCookie() throws Exception {
    	
    	System.out.println("addHttpOnlyPolicy - Response should have httpOnly set on a custom cookie (FOOBAR) added to the response" );
   	    
    	request.getSession(true);
    	
    	WAFTestUtility.createAndExecuteWAFTransaction( "waf-policies/add-httponly-policy.xml", request, response, new HttpOnlyTestFilterChain() );
    	
    	//response.dump();
     
    	String foo = response.getHeader("Set-Cookie");
    	assertTrue( response.getStatus() != HttpServletResponse.SC_MOVED_PERMANENTLY );
    	assertTrue( foo.contains("HttpOnly") );
    	
    }
    
    class HttpOnlyTestFilterChain extends MockFilterChain {
		public void doFilter(ServletRequest arg0, ServletResponse arg1)
				throws IOException, ServletException {
			HttpServletResponse response = (HttpServletResponse)arg1;
			response.addCookie( new Cookie("FOO", "BAR" ) );
		}
    }
    
}
